<?php
namespace AIOSEO\Plugin\Addon\IndexNow\Main;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Verifies the IndexNow key.
 *
 * @since 1.0.0
 */
class Verify {
	/**
	 * Class constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		if (
			is_admin() ||
			wp_doing_ajax() ||
			wp_doing_cron() ||
			aioseo()->helpers->isRestApiRequest()
		) {
			return;
		}

		$apiKey = aioseoIndexNow()->options->indexNow->apiKey;
		if ( empty( $apiKey ) ) {
			return;
		}

		add_action( 'init', [ $this, 'init' ] );
	}

	/**
	 * Initializes the checks to verify.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function init() {
		// Watch for txt requests that match the key.
		add_action( 'wp_loaded', [ $this, 'generateVerifyPage' ] );
	}

	/**
	 * Generates the txt file needed to verify the API key.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function generateVerifyPage() {
		$requestUrl  = ! empty( $_SERVER['REQUEST_URI'] ) ? $_SERVER['REQUEST_URI'] : '';
		$requestPath = wp_parse_url( $requestUrl, PHP_URL_PATH );
		$apiKey      = aioseoIndexNow()->options->indexNow->apiKey;

		$pattern = '/^(\/(' . aioseo()->helpers->escapeRegex( $apiKey ) . ')\.txt)$/i';
		if (
			empty( $requestPath ) ||
			! preg_match( $pattern, $requestPath, $matches ) ||
			empty( $matches[2] )
		) {
			return;
		}

		header( 'Content-Type: text/plain' );
		header( 'X-Robots-Tag: noindex' );

		echo esc_html( $apiKey );
		exit;
	}
}