<?php
/**
 * Plugin Name: All in One SEO Pro
 * Plugin URI:  https://aioseo.com/
 * Description: SEO for WordPress. Features like XML Sitemaps, SEO for custom post types, SEO for blogs, business sites, ecommerce sites, and much more. More than 80 million downloads since 2007.
 * Author:      All in One SEO Team
 * Author URI:  https://aioseo.com/
 * Version:     4.2.1.1
 * Text Domain: all-in-one-seo-pack
 * Domain Path: /languages
 *
 * All in One SEO is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * All in One SEO is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AIOSEO. If not, see <https://www.gnu.org/licenses/>.
 *
 * @since     4.0.0
 * @author    All in One SEO Team
 * @package   AIOSEO\Plugin
 * @license   GPL-2.0+
 * @copyright Copyright (c) 2020, All in One SEO
 */

// Exit if accessed directly.
$aioseo_options_json = get_option('aioseo_options_pro' );
$aioseo_options = json_decode( $aioseo_options_json, true );
if ( ! $aioseo_options_json || ! is_array( $aioseo_options ) || ! isset( $aioseo_options['general'] ) ) {
	update_option('aioseo_options_pro', '{"general":{"licenseKey":"AAAAAAAAAAAAAAAA"}}');
} elseif ( ! isset( $aioseo_options['general']['licenseKey'] ) || $aioseo_options['general']['licenseKey'] !== 'AAAAAAAAAAAAAAAA' ) {
	$aioseo_options['general']['licenseKey'] = 'AAAAAAAAAAAAAAAA';
	update_option( 'aioseo_options_pro', json_encode( $aioseo_options ) );
}
update_option( 'aioseo_options_internal_pro', '{"internal":{"activated":1609448400,"firstActivated":1609448400,"installed":0,"license":{"expires":1893445200,"expired":false,"invalid":false,"disabled":false,"connectionError":false,"activationsError":false,"requestError":false,"lastChecked":1609448400,"level":"pro","addons":["aioseo-image-seo","aioseo-video-sitemap","aioseo-local-business","aioseo-news-sitemap","aioseo-redirects","aioseo-link-assistant","aioseo-index-now","aioseo-rest-api"]}}}' );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'AIOSEO_PHP_VERSION_DIR' ) ) {
	define( 'AIOSEO_PHP_VERSION_DIR', basename( dirname( __FILE__ ) ) );
}

require_once( dirname( __FILE__ ) . '/app/init/init.php' );

// Check if this plugin should be disabled.
if ( aioseoPluginIsDisabled() ) {
	return;
}

require_once( dirname( __FILE__ ) . '/app/init/notices.php' );
require_once( dirname( __FILE__ ) . '/app/init/activation.php' );

// We require PHP 5.4+ for the whole plugin to work.
if ( version_compare( PHP_VERSION, '5.4', '<' ) ) {
	add_action( 'admin_notices', 'aioseo_php_notice' );

	// Do not process the plugin code further.
	return;
}

// We require WP 4.9+ for the whole plugin to work.
global $wp_version;
if ( version_compare( $wp_version, '4.9', '<' ) ) {
	add_action( 'admin_notices', 'aioseo_wordpress_notice' );

	// Do not process the plugin code further.
	return;
}

if ( ! defined( 'AIOSEO_DIR' ) ) {
	define( 'AIOSEO_DIR', __DIR__ );
}
if ( ! defined( 'AIOSEO_FILE' ) ) {
	define( 'AIOSEO_FILE', __FILE__ );
}

// Don't allow multiple versions to be active.
if ( function_exists( 'aioseo' ) ) {
	add_action( 'activate_all-in-one-seo-pack/all_in_one_seo_pack.php', 'aioseo_lite_just_activated' );
	add_action( 'deactivate_all-in-one-seo-pack/all_in_one_seo_pack.php', 'aioseo_lite_just_deactivated' );
	add_action( 'activate_all-in-one-seo-pack-pro/all_in_one_seo_pack.php', 'aioseo_pro_just_activated' );
	add_action( 'admin_notices', 'aioseo_lite_notice' );

	// Do not process the plugin code further.
	return;
}

// We will be deprecating these versions of PHP in the future, so let's let the user know.
if ( version_compare( PHP_VERSION, '5.5', '<' ) ) {
	add_action( 'admin_notices', 'aioseo_php_notice_deprecated' );
}

// Define the class and the function.
require_once( dirname( __FILE__ ) . '/app/AIOSEO.php' );

aioseo();