<div class="wrap about-wrap ls-about-page">

	<!-- LayerSlider Logo & continue button -->
	<img src="<?php echo LS_ROOT_URL ?>/static/admin/img/ls-tb.png" class="ls-about-img" alt="LayerSlider">

	<!-- Main title -->
	<h1 class="about-heading"><?php _e( 'Welcome to LayerSlider WP 6', 'LayerSlider' ); ?></h1>
	<div class="about-text"><?php _e( 'Thank you for installing LayerSlider WP! Version 6 is our biggest update yet.', 'LayerSlider' ); ?></div>

	<a href="<?php echo admin_url('admin.php?page=layerslider') ?>" class="button button-primary button-hero ls-start-button">
		<?php _e("Let's Get Started", "LayerSlider") ?>
	</a>

	<!-- Share sheet -->
	<div class="ls-share-template">
		<a href="https://www.facebook.com/sharer/sharer.php?u=https://layerslider.kreaturamedia.com" target="_blank">
			<i class="dashicons dashicons-facebook-alt"></i> <?php _e('Share', 'LayerSlider') ?>
		</a>

		<a href="http://www.twitter.com/share?url=https%3A%2F%2Flayerslider.kreaturamedia.com&amp;text=Check%20out%20LayerSlider%20WP%2C%20an%20awesome%20%23slider%20%23plugin%20for%20%23WordPress&amp;via=kreaturamedia" target="_blank">
			<i class="dashicons dashicons-twitter"></i> <?php _e('Tweet', 'LayerSlider') ?>
		</a>

		<a href="https://plus.google.com/share?url=https://layerslider.kreaturamedia.com" target="_blank">
			<i class="dashicons dashicons-googleplus"></i> +1
		</a>
	</div>

	<!-- Tabs -->
	<div class="km-tabs">
		<a href="#" class="active"><?php _e("What's New", "LayerSlider"); ?></a>
		<a href="#"><?php _e('First steps', 'LayerSlider'); ?></a>
		<a href="#"><?php _e('Resources', 'LayerSlider'); ?></a>
	</div>
	<div class="km-tabs-content">

		<!-- What's New -->
		<div class="active">
			<figure><?php _e('The newest key features introduced in major updates', 'LayerSlider') ?></figure>
			<div class="km-tabs-inner km-about-news-sections">
				<div>
					<img src="">
					<h2><?php _e('Faster, Better, Prettier', 'LayerSlider') ?></h2>
					<p><?php _e('Both the admin interface and front-end sliders load faster and perform better. This release has numerous bug fixes and improvements. So much actually, that we can\'t even write a complete list. The admin interface has also been redesigned a bit to provide familiar but much cleaner and easier controls.', 'LayerSlider') ?></p>
				</div>

				<div>
					<img src="">
					<h2><?php _e('Reworked Responsive Mode, New Slider Layouts, Device Dependent Layouts', 'LayerSlider') ?></h2>
					<p><?php _e('The new responsive mode performs significantly better and in most cases it does not require any special configuration. LayerSlider now also have multiple new layout modes like full size, hero screne and full screen sliders. These will allow new use cases such as running slideshows on billboards. It\'s also possible to make different layouts for different devices (phones, tables, desktop).', 'LayerSlider') ?></p>
				</div>

				<div>
					<img src="">
					<h2><?php _e('New Transitions, Text Animations, Loop, Hover, Filters and a lot more', 'LayerSlider') ?></h2>
					<p><?php _e('We\'ve added lots of new transition options, which greatly extends the capabilities of your slideshows. You can now create chainable multi-step animations enhanced with stylish text transitions and interactive hover animations. There\'s also hidden surprises like the much requested Ken Burns effect, 3D parallax effect, and our new "play by scroll" feature. Oh, and don\'t forget to try out filters, which can be used to apply blur, sepia, grayscale etc. effects to your layers among many other.', 'LayerSlider') ?></p>
				</div>

				<div>
					<img src="">
					<h2><?php _e('Static Layers', 'LayerSlider') ?></h2>
					<p><?php _e('Layers can now enter and leave on any slide. You can easily build more complex animations where layers persist across multiple slides. Or just use it as an "always on top" feature.', 'LayerSlider') ?></p>
				</div>


				<div>
					<img src="">
					<h2><?php _e('Undo and Redo', 'LayerSlider') ?></h2>
					<p><?php _e('Web apps usually don\'t have controls to undo unwanted/accidental changes. LayerSlider now has. And it\'s even preserved for later use, whenever you need it.', 'LayerSlider') ?></p>
				</div>

				<div>
					<img src="">
					<h2><?php _e('Multi-selection, Resize, Rulers + Guides', 'LayerSlider') ?></h2>
					<p><?php _e('Do you ever wanted to move around multiple layers and once? LayerSlider 6 now supports multiple selection, which allows you altering groups of layers seamlessly. With rulers and keyboard shortcuts, you can now move/resize/etc your layers with precision. There\'s also Guides and a snap to feature built in.', 'LayerSlider') ?></p>
				</div>

				<div>
					<img src="">
					<h2><?php _e('Keyboard shortcuts &amp; Popout Editor', 'LayerSlider') ?></h2>
					<p><?php _e('The slider builder interface can now be controlled by keyboard shortcuts. These shortcuts also introduces a lot of new features, like editing layers content right in the preview area or copying and pasting layers across slides and sliders. We\'ve also introduced the Popout Editor, which transforms the layer options area into a floating window that can be resized and placed wherever you want. This makes it extremely easy to edit everything in one place, without the need to scroll up and down constantly.', 'LayerSlider') ?></p>
				</div>


				<div>
					<img src="">
					<h2><?php _e('Image Editor', 'LayerSlider') ?></h2>
					<p><?php _e('With the help of Adobe\'s Creative SDK, LayerSlider 6 now has a built-in image editor. You can perform common tasks like resizing, cropping, rotating images, as well as photo retouching, adding frames, text, effects, stickers and a lot more. It\'s like a mini-Photoshop.', 'LayerSlider') ?></p>
				</div>

				<div>
					<img src="">
					<h2><?php _e('And a lot more ...', 'LayerSlider') ?></h2>
					<p><?php _e('There\'s way more new features and improvement that we can list here: scheduled sliders, retina-ready, serving dynamically scaled images to reduce data usage and speed up page loads on mobile devices, redesigned transition builder with import feature, continuous live previews, new interactive timeline, reworked multimedia layer support with custom video poster and controls, custom HTML attributes, drag \'n\' drop image upload, smart links, copy & paste layer styles and transition settings, named slides, new slider/slide background settings, auto-fit zoom, align layers feature. <br><br>The number of new features almost never end, but this list must. :)', 'LayerSlider') ?></p>
				</div>

				<br><br>
				<div>
					<img src="">
					<h2><?php _e("The future of LayerSlider", "LayerSlider") ?></h2>
					<p><?php _e("LayerSlider 6 is just the beginning of our awesome new ideas. One of the main goals was to completely rebuild the plugin architecture and modernize its core. This allows us to implement new features way more faster and improve upon existing functionality with an easily maintainable code base. Beyond the predictable feature updates like the complete overhaul of skins, dynamic contents, etc (which will arrive very soon); we already have an experimental offline slider editor and preliminary support for LayerSlider extensions. This later one will soon be available for anyone to extend the plugins capabilities.", "LayerSlider") ?></p>
				</div>
			</div>
		</div>


		<!-- First Steps -->
		<div>
			<figure><?php _e('Considerations before starting to use the plugin', 'LayerSlider') ?></figure>
			<div class="km-tabs-inner">
				<ul>
					<li class="gap">
						<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#updating" target="_blank">
							<?php _e('Active the plugin to receive auto updates and premium support', 'LayerSlider') ?>
						</a>
						<p><?php _e('Keep the plugin up-to-date by activating the auto-update feature. We regularly release updates with new features, bug fixes and other improvements.', 'LayerSlider') ?></p>
					</li>
					<li class="gap">
						<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#demo-sliders" target="_blank">
							<?php _e('Check out the included demo sliders', 'LayerSlider') ?>
						</a>
						<p><?php _e("We've bundled several sample sliders into the plugin, so you can see how they built. You can find really simple sliders as well as compled and content rich ones.", 'LayerSlider') ?></p>
					</li>
					<li class="gap">
						<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#overview" target="_blank">
							<?php _e('Read online resouces to get help', 'LayerSlider') ?>
						</a>
						<p><?php _e('We have online resouces where you can find help whether if you get stuck, experience an issue or just have a question about the item.', 'LayerSlider') ?></p>
						<ul>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html" target="_blank">
								<?php _e('End-User documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/developers.html" target="_blank">
								<?php _e('Developer documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="http://codecanyon.net/item/layerslider-responsive-jquery-slider-plugin/922100/comments?ref=kreatura" target="_blank">
									<?php _e('CodeCanyon discussion', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/" target="_blank">
									<?php _e('Item FAQs', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</li>
				</ul>
			</div>
		</div>


		<!-- Resources -->
		<div>
			<figure><?php _e('Frequently asked questions and online resources', 'LayerSlider') ?></figure>
			<div class="km-tabs-inner">
				<div class="five-col clearfix">
					<div class="col">
						<h3><?php _e('Preface', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html" target="_blank">
									<?php _e('Introduction', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#support" targee="_blank">
									<?php _e('Support', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/#group-1" target="_blank">
									<?php _e('Support Policies', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://news.kreaturamedia.com/layerslider/" target="_blank">
									<?php _e('Release Notes', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Licesing', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://codecanyon.net/licenses/terms/regular" target="_blank">
									<?php _e('Regular License', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="http://codecanyon.net/licenses/terms/extended" target="_blank">
									<?php _e('Extended License', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="http://codecanyon.net/licenses/faq" target="_blank">
									<?php _e('Envato License FAQ', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/#group-3" target="_blank">
									<?php _e('Licensing Questions', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/#group-3&entry-18" target="_blank">
									<?php _e('In-Stock Usage', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Getting Started', 'LayerSlider') ?></h3>
						<ul>

							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#updating" target="_blank">
									<?php _e('Plugin updates', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#demo-sliders" target="_blank">
									<?php _e('Import demo content', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html" target="_blank">
									<?php _e('Online Documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html#troubleshooting" target="_blank">
									<?php _e('Troubleshooting', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e('Resources', 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/documentation.html" target="_blank">
									<?php _e('End-User Documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/docs/layersliderwp/developers.html" target="_blank">
									<?php _e('Developer Documentation', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="https://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/" target="_blank">
									<?php _e('Item FAQs', 'LayerSlider') ?>
								</a>
							</li>
							<li>
								<a href="http://codecanyon.net/item/layerslider-responsive-wordpress-slider-plugin-/1362246/comments?ref=kreatura" target="_blank">
									<?php _e('CodeCanyon discussion', 'LayerSlider') ?>
								</a>
							</li>
						</ul>
					</div>
					<div class="col">
						<h3><?php _e("Stay Updated", 'LayerSlider') ?></h3>
						<ul>
							<li>
								<a href="http://codecanyon.net/user/kreatura" target="_blank">
								<?php _e('Follow us on Envato', 'LayerSlider') ?></a>
							</li>
							<li>
								<a href="https://www.facebook.com/kreaturamedia/" target="_blank">
								<?php _e('Follow us on Facebook', 'LayerSlider') ?></a>
							</li>
							<li>
								<a href="https://twitter.com/kreaturamedia" target="_blank">
								<?php _e('Follow us on Twitter', 'LayerSlider') ?></a>
							</li>
							<li>
								<a href="https://www.youtube.com/user/kreaturamedia" target="_blank">
								<?php _e('Watch our YouTube channel', 'LayerSlider') ?></a>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>

	</div>

</div>